#ifndef ENTITE_H
#define ENTITE_H

#include "sprite.h"
#include "PhysicData.h"

class Entite
{
    protected:
        int m_iX,m_iY;
        Sprite * m_pSprite;
        PhysicData *m_pPhysicData;
        bool m_bBouger;
        char *m_szNom;
    public:
        Entite();
        Entite(const int iX,const int iY);
        ~Entite();
        
        Sprite * getSprite() { return m_pSprite ; }

        int getX() const { return m_iX ; }
        void addX(const int iX) { m_iX+=iX; m_bBouger=true; }
        void setX(const int iX);

        virtual void init() {}

        int getY() const { return m_iY ; }
        void addY(const int iY) { m_iY+=iY; m_bBouger=true; }
        void setY(const int iY);

        void setNom(char *szNom) ;//{ this->m_szNom= szNom;}
        char *getNom() { return m_szNom ; }

        void initSprite() { m_pSprite=new Sprite; }
        
        void setBouger(const bool bBouger) { m_bBouger=bBouger; }
        bool getBouger() { return m_bBouger ; }
                
        PhysicData *getPhysicData() { return m_pPhysicData ; }
        void setPhysicData(PhysicData *pPhysicData);
};

#endif
